//=============================================================================

/*:
 * @plugindesc オプションにHelpウィンドウを追加します。
 * 
 * @author LefTonbo
 *
 */

//=============================================================================

(function() {

var helpTexts = {
  'alwaysDash': '常に超高速移動を行うか設定します',
  'commandRemember': 'バトル時、コマンド選択位置を記憶するか設定します',
  'bgmVolume': 'ゲーム中に流れる音楽（BGM）の音量を設定します',
  'bgsVolume': '雨や風の音など環境音（BGS）の音量を設定します',
  'meVolume': 'ファンファレーなど演出音楽（ME）の音量を設定します',
  'seVolume': '様々な効果音（SE）の音量を設定します',
  'animateTiles': 'タイルのアニメーションを有効にするか設定します\nOFF にするとパフォーマンスが改善します',
  'TxLighting': '光陰を描画するか設定します\nOFF にすると光が無くなりますがパフォーマンスが改善します',
  'synchFps': '高負荷時にコマ飛びさせてFPSを安定させるか設定します',
  'relativePad': 'ドラッグで移動するタッチパットを使うか設定します\nOFF にするとMV従来のタッチ移動になります',
  'keyConfig': 'キーボードのボタン割り当て設定を行います',
  'gamepadConfig': 'ゲームパットのボタン割り当て設定を行います',
  'musicMenu': 'サウンドテストを行います\n',
  'gameEnd': 'ゲームを終了します\n\\c[10]セーブされていない進捗は破棄されます！'
}
var optionGenerals = [
  'alwaysDash', 'commandRemember', 'bgmVolume', 'bgsVolume', 'bgsVolume', 'meVolume', 'seVolume'
];
var atsumaruWarning1 = '\\c[2]※この設定は他アツマール作品にも影響します';
var atsumaruWarning2 = '\\c[10]※MVの仕様上、他アツマール作品起動時に初期化されます';

var isAtsumaru = (window.RPGAtsumaru !== undefined);

//=============================================================================
// Scene_Options
//=============================================================================

var _Scene_Options_create = Scene_Options.prototype.create;
Scene_Options.prototype.create = function() {
  _Scene_Options_create.call(this);
  this.createHelpWindow();
};

Scene_Options.prototype.createHelpWindow = function() {
  this._helpWindow = new Window_Help();
  this.addWindow(this._helpWindow);
  //this._helpWindow.opacity = 0;
  //this._helpWindow.showBackgroundDimmer();
  this._optionsWindow.setHelpWindow(this._helpWindow);
  this._optionsWindow.updatePlacement();
};

//=============================================================================
// Window_Options
//=============================================================================

Window_Options.prototype.updatePlacement = function() {
  if (!this._helpWindow) return;
  this.x = (Graphics.boxWidth - this.width) / 2;
  this.y = this._helpWindow.height + (Graphics.boxHeight - this._helpWindow.height - this.height) / 2;
};

Window_Options.prototype.updateHelp = function() {
  Window_Selectable.prototype.updateHelp.call(this);
  var symbol = this.currentSymbol();
  var help = helpTexts[symbol];
  if (help !== undefined) {
    if (isAtsumaru && symbol !== 'gameEnd') {
      var addHelp = '';
      if (optionGenerals.indexOf(symbol) >= 0) {
        addHelp = atsumaruWarning1;
      } else {
        addHelp = atsumaruWarning2;
      }
      if (help.match(/(.+)\n(.*)/i)) {
        help = RegExp.$1 + '\\}\n' + RegExp.$2 + addHelp;
      } else {
        help += '\n' + addHelp;
      }
    }
    this._helpWindow.setText(help);
  }
};

//=============================================================================

})();

// EOF
